{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:20:40 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMSystem, MMPCMSup, MMUtils, ExtCtrls, MMObj, MMDSPObj,
  MMWavOut;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    RadioGroup1: TRadioGroup;
    Button4: TButton;
    Button5: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  public
    Handle1,Handle2,Handle3,Handle4: THandle;
    wfx1,wfx2,wfx3,wfx4: TWaveFormatEx;
    function  OpenDevice(ID: integer; pwfx: PWaveFormatEx): integer;
    procedure CloseDevice(var Handle: THandle);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
     // change the device ID's to your card(s)
     DeviceID1 = 0;
     DeviceID2 = 1;
     DeviceID3 = 2;
     DeviceID4 = 3;

{------------------------------------------------------------------------------}
procedure WaveOutFunc(hWaveOut:HWaveOut;wMsg:UINT;dwInstance,dwParam1,dwParam2:Longint);export;stdcall;
begin
end;

{------------------------------------------------------------------------------}
function TForm1.OpenDevice(ID: integer; pwfx: PWaveFormatEx): integer;
var
   S: string;
   Err: integer;
begin
   Result := 0;

   Err := WaveOutOpen(@Result,ID,pwfx,0, 0,WAVE_FORMAT_QUERY);

   if (Err = 0) then
   case RadioGroup1.ItemIndex of
        0: Err := WaveOutOpen(@Result,ID,pwfx,0,0,0);
        1: Err := WaveOutOpen(@Result,ID,pwfx,Handle,Longint(Self),CALLBACK_WINDOW);
        2: Err := WaveOutOpen(@Result,ID,pwfx,GetCurrentThreadID,Longint(Self),CALLBACK_THREAD);
        3: Err := WaveOutOpen(@Result,ID,pwfx,Longint(@WaveOutFunc),Longint(Self),CALLBACK_FUNCTION);
   end;

   if (Err <> 0) then
      S := Format('Device %d NOT Opened',[ID])
   else
      S := Format('Device %d now Open',[ID]);

   MessageDlg(S, mtInformation,[mbOK], 0);
end;

{------------------------------------------------------------------------------}
procedure TForm1.CloseDevice(var Handle: THandle);
begin
   if (Handle <> 0) then
   begin
      WaveOutClose(Handle);
      Handle := 0;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   pcmBuildWaveHeader(@wfx1, 16, 2, 44100);
   pcmBuildWaveHeader(@wfx2, 16, 1, 22050);
   pcmBuildWaveHeader(@wfx3, 8,  2, 11025);
   pcmBuildWaveHeader(@wfx4, 16, 1, 11025);
   Handle1 := 0;
   Handle2 := 0;
   Handle3 := 0;
   Handle4 := 0;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button1Click(Sender: TObject);
begin
   if Handle1 <> 0 then exit;

   Handle1 := OpenDevice(DeviceID1,@wfx1);
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button2Click(Sender: TObject);
begin
   if Handle2 <> 0 then exit;

   Handle2 := OpenDevice(DeviceID2,@wfx2);
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button4Click(Sender: TObject);
begin
   if Handle3 <> 0 then exit;

   Handle3 := OpenDevice(DeviceID3,@wfx3);
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button5Click(Sender: TObject);
begin
   if Handle4 <> 0 then exit;

   Handle4 := OpenDevice(DeviceID4,@wfx4);
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button3Click(Sender: TObject);
begin
   CloseDevice(Handle1);
   CloseDevice(Handle2);
   CloseDevice(Handle3);
   CloseDevice(Handle4);
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Button3Click(nil);
end;

end.
